/*
 * Alignment.h
 *
 */

#ifndef ALIGNMENT_H_
#define ALIGNMENT_H_

#include "constants.h"
#include <iostream>
#include <stdlib.h>
#include <boost/algorithm/string.hpp>
#include <math.h>
#include <vector>
#include <fstream>
#include <exception>

using namespace std;

class Alignment {
  float n_rows;
  unsigned short int n_cols;
  string TF;
  string filename;
  std::vector <std::vector<float> > n_i;// to hold the frequencies for each column
  //	float ** n_i;
  std::vector <std::vector<std::vector<std::vector<float> > > > n_ij; // to hold the mutual columns frequency
  std::vector <std::vector<float> > lp_i;// to hold the log-probabilities for each column
  std::vector <std::vector<std::vector<std::vector<float> > > > lp_ij; // to hold the pair column log-probabilities
public:
  Alignment(string);
  Alignment(Alignment &other); // copy constructor
  Alignment();
  virtual ~Alignment();
  void read_alignment(string);
  void set_logprobs(double);
  void reset_counts();
  void renormalize_counts();
  void add_foreground_counts(string sequence, string revcomp, vector<double> sequence_scores, vector<double> rev_scores,double lam);
  float nrows();
  unsigned short int ncols();
  float get_n_i(char, unsigned short int);
  float get_n_i(unsigned short int, unsigned short int);	// same version but without convert() function
  float get_lp_i(char, unsigned short int);
  float get_lp_i(unsigned short int, unsigned short int);	// same version but without convert() function
  float get_n_ij(char, char, unsigned short int, unsigned short int);
  float get_n_ij(unsigned short int, unsigned short int, unsigned short int, unsigned short int);	// same version but without convert( function
  float get_lp_ij(char, char, unsigned short int, unsigned short int);
  float get_lp_ij(unsigned short int, unsigned short int, unsigned short int, unsigned short int);	// same version but without convert( function
  string get_TF();
  void initialize_n_i(unsigned short int);
  void initialize_n_ij(unsigned short int);
  void initialize_lp_i(unsigned short int);
  void initialize_lp_ij(unsigned short int cols);
};

#endif /* ALIGNMENT_H_ */
