//============================================================================
// Name        : DWT_model.cpp
// Author      : Saeed Omidi, Mihaela Zavolan, and Erik van Nimwegen
// Version     :
// Copyright   : Your copyright notice
// Description : Positional Dependency based on DWT model in C++, Ansi-style
//============================================================================

#include <iostream>
#include <time.h>
#include <vector>
#include <iomanip>
#include "constants.h"
#include "Alignment.h"
#include "Decomposition.h"
#include "Score.h"
#include "ParameterFile.h"


using namespace std;

int main(int argc, char* argv[]){
	if (argc != 2){
		cerr << "Calculates the pairwise dependency posterior between all pairs of positions." << endl;
		cerr << "Usage: positional_dependency_posterior dwt_file" << endl;
		exit(1);
	}

	string dwt_model_file = argv[1];
	Alignment alignment(dwt_model_file);
	ParameterFile parameters;
	Score S(alignment, alignment.get_TF(), parameters);
	for(unsigned int i=0; i<alignment.ncols(); i++){
	  for(unsigned int j=0;j<i;j++){
	    printf("%d\t%d\t%.4lf\t%lf\n", j, i, S.posterior(i,j),S.give_logR(i,j));
	  }
	}
	return 0;
}
