
#ifndef SCORE_H_
#define SCORE_H_

#include <boost/math/special_functions/gamma.hpp>
#include <vector>
#include "constants.h"
#include "Decomposition.h"
#include "BackgroundModel.h"
#include "ParameterFile.h"
#include "Alignment.h"

using namespace std;

const double DEF_SCORE = -100.0;

class Score {
  Alignment alignment;
  
  std::vector <std::vector<double> > logR;
  std::vector <std::vector<double> > rescaled_R;
  double laplacian_determinant;
  string tf;
  double PRECISION;	// for re-scaling the numbers in LogR (default 5.0)
  double LAMBDA;
  ParameterFile parameters;
  BackgroundModel background;
  double alpha_exponent;	// in order to re-scale all logRs by the same alpha_exponent for the original logR matrix
  Mode mode; // the type of run that we want to do
public:
  Score();
  Score(Alignment&, string, ParameterFile);
  virtual ~Score();
  std::vector <std::vector<double> > calculate_logR();
  double find_alpha_exponent(std::vector <std::vector<double> >); // in order to find the alpha_exponent of a given matrix
  double determinant();
  double rescale_laplacian_determinant(std::vector <std::vector<double> >, double,double); 
  std::vector <std::vector<double> > logR_plus_seq_alpha(string,double);  
  string get_TF();
  std::vector<double> score_sequence(string); // calculate scores along an entire sequence
  double score_window(string);	// score a window the size of the motif depending on the run mode
  std::vector<std::vector<double> > contract_edge(unsigned int, unsigned int);
  double posterior(unsigned int, unsigned int);
  double give_logR(unsigned int ,unsigned int);
  // helpers
  bool char_is_valid(char);
  bool is_valid(string);
};


#endif /* SCORE_H_ */
