/*
 * Sequence.cpp
 *
 */

#include "Sequence.h"

// default constructor
Sequence::Sequence() {
  name = "";
  positive = true;
  sequence = "";
  length = 0;
}

Sequence::Sequence(string n, string s) {
  name = n;
  //if(name.find("random_chrR") < name.length()){
  //  positive = false;
  //}
  //else{
  //  positive = true;
  //}
  //We removed the possibility to having negative results
  positive = true;
  sequence = s;
  revcomp = reverse_complement(sequence);
  length = sequence.length();
  // we won't initialize the score array because it depends on the motif length
  // it will be set by the compute_scores function
}

Sequence::~Sequence() {
  
}

inline string Sequence::reverse_complement(string str){
  string c_str = str;
  unsigned int len = str.length();
  
  for (unsigned int i = 0; i < len; i++){
    c_str [i] = complement(str[i]);
  }
  // now reverse it
  reverse(c_str.begin(), c_str.end());
  return c_str;
}

inline char Sequence::complement(char c){
  switch (c){
    case 'A':
      return 'T';
    case 'T':
      return 'A';
    case 'C':
      return 'G';
    case 'G':
      return 'C';
    case 'N':
      return 'N';
    default:
      cerr << "Sequence contains invalid character " << c << "\nQuitting\n";
      exit(1);
  }
}

void Sequence::get_scores(Score score) {
  // just pass the sequence to the score class
  // this will return a vector of doubles of the size sequence length - motif length + 1
  scores = score.score_sequence(sequence);
  rc_scores = score.score_sequence(revcomp);
}

std::vector<double> Sequence::give_scores() {
  return scores;
}

std::vector<double> Sequence::give_rc_scores() {
  return rc_scores;
}

string Sequence::give_seq() {
  return sequence;
}

string Sequence::give_rc_seq() {
  return revcomp;
}

string Sequence::give_name() {
  return name;
}

bool Sequence::is_positive(){
  return positive;
}


std::vector<unsigned int> Sequence::give_letter_counts() {
  std::vector<unsigned int> counts;
  counts.resize(ALPH_NUM, 0);
  for(unsigned int i = 0; i < length; i++) {
    switch(sequence[i]){
    case 'A':
    case 'a':
      counts[0]++;
    break;
    case 'C':
    case 'c':
      counts[1]++;
    break;
    case 'G':
    case 'g':
      counts[2]++;
    break;
    case 'T':
    case 't':
      counts[3]++;
    break;
    }
  }
  return counts;
}
