/*
 * Sequence.h
 *
 */

#ifndef SEQUENCE_H_
#define SEQUENCE_H_

#include <string>
#include <iomanip>
#include <iostream>
#include <boost/algorithm/string.hpp>
#include <boost/algorithm/string/replace.hpp>
#include "Score.h"
#include "ParameterFile.h"

using namespace std;

class Sequence {
private:
  string name;
  bool positive;
  string sequence;
  string revcomp;
  unsigned int length; // sequence length, not scores array size!
  std::vector<double> scores; 
  std::vector<double> rc_scores; 
public:
  Sequence();
  Sequence(string name, string sequence);
  virtual ~Sequence();
  inline string reverse_complement(string); // reverse complement a sequence
  inline char complement(char);	// complement a nucleotide
  inline char char_is_valid(char);
  inline bool is_valid(string);
  void get_scores(Score);
  string give_name();
  std::vector<double> give_scores();
  std::vector<double> give_rc_scores();
  std::vector<unsigned int> give_letter_counts();
  string give_seq();
  string give_rc_seq();
  bool is_positive();
};

#endif 
