/*
 * constants.h
 */

#ifndef CONSTANTS_H_
#define CONSTANTS_H_

#include <boost/math/special_functions/gamma.hpp>

#define MAX(a,b)	\
       ({ typeof (a) _a = (a); \
           typeof (b) _b = (b); \
         _a > _b ? _a : _b; })

#define SIGN(a,b) ((b) >= 0.0 ? fabs(a) : -fabs(a))

enum Nucleotides {A=65, C=67, G=71, T=84};	// The numbers that assigned are ASCII codes of ACGT
// this can be used in statements like "if (vec[1] == A)"
#define ALPH_NUM	4
//#define LAMBDA		0.125
#define LGAMMA_4LAMBDA	(2*(lgamma(4*LAMBDA)))
#define LGAMMA_LAMBDA	(lgamma(LAMBDA))
#define LOG_10 			(log(10.))
#define TINY 			(1e-20)

// Some enumeration types used for other parameters of the run
// Mode determines what type of motif is used.
enum Mode {UNKNOWN, DWT, ADJ, PWM};
// BgType determines how we initialize the background model.
enum BgType {UNIFORM, FROMPARAM, FROMSEQ};
// alphabet
enum Letters {a, c, g, t};
const char letters[ALPH_NUM] = {'A', 'C', 'G', 'T'};

double FMAX(double,double);	// find the biggest parameter of types double

double ABS(double);	// find the Absolute value of a parameter of type double

short int convert(char);	// converting nucleotides to appropriate numbers for referring in vectors


#endif /* CONSTANTS_H_ */
