/*
 * BackgroundModel.cpp
 *
 */

#include <math.h>
#include <iostream>
#include "BackgroundModel.h"


BackgroundModel::BackgroundModel() {
}

BackgroundModel::BackgroundModel (std::vector <float> probs){
  if(probs.size() != ALPH_NUM) {
    cerr << "Vector of probabilities is different than alphabet size" << endl;
    //    exit(1);
  }
  lpA = log(probs[0]);
  lpC = log(probs[1]);
  lpG = log(probs[2]);
  lpT = log(probs[3]);
}

BackgroundModel::BackgroundModel(BackgroundModel &other) {
  // copy constructor
  lpA = other.lpA;
  lpC = other.lpC;
  lpG = other.lpG;
  lpT = other.lpT;
}

BackgroundModel::~BackgroundModel() {
	// TODO Auto-generated destructor stub
}

void BackgroundModel::change_background(std::vector <float> probs){
  lpA = log(probs[0]);
  lpC = log(probs[1]);
  lpG = log(probs[2]);
  lpT = log(probs[3]);
}


float BackgroundModel::get_lp(char alpha){
  switch (alpha){
  case 'A':
    return lpA;
    break;
  case 'C':
    return lpC;
    break;
  case 'G':
    return lpG;
    break;
  case 'T':
    return lpT;
    break;
  }
  return -1.38629; //return log(1/4) is the default (should not occur in practice) 
}

float BackgroundModel::get_lp(unsigned short int alpha){
  if(alpha == 0){
      return lpA;
  }
  else if(alpha == 1){
    return lpC;
  }
  else if(alpha == 2){
    return lpG;
  }
  else{
    return lpT;
  }
}
