/*
 * ParameterFile.h
 *
 */

#ifndef PARAMETERFILE_H_
#define PARAMETERFILE_H_

#include <iostream>
#include <vector>
#include <iomanip>
#include <string>
#include <fstream>
#include <stdlib.h>
#include "constants.h"

using namespace std;

// default parameters
const double DEF_NC_FREQ = 0.25;
const double DEF_LOW_SCORE = -50.0;
const string DEF_FILE_NAME = "NULL";
const double DEF_PRECISION = 25.0;
const double DEF_LAMBDA = 0.125; 
const double DEF_PADDING = 0.0;


class ParameterFile {
  // name of the parameter file
  string file_name;

  // name of the directory where the results will be written
  string output_dir;
 
  // how do we want to set the background: uniform, from parameter file, from the input sequences
  BgType background_type;

  // vector with mono-nucleotide background
  std::vector<float> background;

  // maybe delete this
  bool background_is_set;

  double precision;	// by default is DEF_PRECISION
  double paddingfrac; //What fraction of the motif length to add as padding on both sides
  double lowest_score;	// the minimum score for printing out or saving into the file, in LOG space
  double lambda;

  // the type of run we want to do
  Mode mode;

  // do we train the DWT?
  bool train_DWT;

public:
  ParameterFile();
  ParameterFile(string);
  virtual ~ParameterFile();
  std::vector<float> give_background();
  double give_precision();
  string give_output_dir();
  BgType give_background_type();
  double give_lowest_score();
  double give_lambda();
  double give_paddingfrac();
  Mode give_mode();
  bool give_train_DWT();
  void initialize_background (ifstream&);
  void initialize_background_type (ifstream&);
  void initialize_minimum_score (ifstream&);
  void initialize_output_dir (ifstream&);
  void initialize_precision(ifstream&);
  void initialize_paddingfrac(ifstream&);
  void initialize_mode(ifstream&);
  void initialize_train_DWT(ifstream&);
  void change_background(std::vector <float>);
};

#endif /* PARAMETERFILE_H_ */
